@extends('layouts.admin')

@section('title', $news->title)

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>View News Article</h1>
            <div>
                <a href="{{ route('admin.news.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to News
                </a>
                @can('manage news')
                <a href="{{ route('admin.news.edit', $news) }}" class="btn btn-primary ml-sm">
                    <i class="fas fa-edit"></i> Edit Article
                </a>
                @endcan
            </div>
        </div>
        <p>Published on {{ $news->formatted_date }} • {{ $news->reading_time }}</p>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="dashboard-card mb-md">
                <div class="dashboard-card-header">
                    <h3>{{ $news->title }}</h3>
                </div>
                <div class="dashboard-card-body">
                    @if($news->image)
                    <div class="news-featured-image mb-md">
                        <img src="{{ asset('storage/' . $news->image) }}" alt="{{ $news->title }}" class="w-100 rounded">
                    </div>
                    @endif

                    <div class="news-short-description mb-md">
                        <h4>Short Description</h4>
                        <p>{{ $news->short_description }}</p>
                    </div>

                    <div class="news-content">
                        <h4>Content</h4>
                        <div class="mt-sm">
                            {!! nl2br(e($news->content)) !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="dashboard-card mb-md">
                <div class="dashboard-card-header">
                    <h3>Article Information</h3>
                </div>
                <div class="dashboard-card-body">
                    <table class="table table-details">
                        <tbody>
                            <tr>
                                <th>ID</th>
                                <td>{{ $news->id }}</td>
                            </tr>
                            <tr>
                                <th>Slug</th>
                                <td><code>{{ $news->slug }}</code></td>
                            </tr>
                            <tr>
                                <th>Author</th>
                                <td>
                                    @if($news->author)
                                        <div class="d-flex align-items-center">
                                            <img src="{{ $news->author->avatar ?? asset('images/default-avatar.png') }}" alt="{{ $news->author->name }}" class="avatar-sm mr-sm">
                                            <span>{{ $news->author->name }}</span>
                                        </div>
                                    @else
                                        Unknown
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Created</th>
                                <td>{{ $news->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Last Updated</th>
                                <td>{{ $news->updated_at->format('M d, Y H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Reading Time</th>
                                <td>{{ $news->reading_time }}</td>
                            </tr>
                        </tbody>
                    </table>

                    @can('delete news')
                    <div class="mt-md">
                        <form action="{{ route('admin.news.destroy', $news) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this news article? This action cannot be undone.');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-trash"></i> Delete Article
                            </button>
                        </form>
                    </div>
                    @endcan
                </div>
            </div>

            <div class="dashboard-card">
                <div class="dashboard-card-header">
                    <h3>Frontend View</h3>
                </div>
                <div class="dashboard-card-body">
                    <p>View how this article appears on the frontend:</p>
                    <a href="{{ url('/news/' . $news->slug) }}" class="btn btn-primary w-100 mt-sm" target="_blank">
                        <i class="fas fa-external-link-alt"></i> View on Website
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .news-content {
        line-height: 1.6;
    }
    
    .news-content p {
        margin-bottom: 1rem;
    }
    
    .news-featured-image img {
        max-height: 400px;
        object-fit: cover;
    }
</style>
@endsection